/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.entity;

import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.serialization.ObjectBuilder;
import java.lang.reflect.Field;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class EntityHelper {
    private EntityHelper() {
    }

    public static ItemStack getItemInHand(LivingEntity player, HumanoidArm hand) {
        return player.m_21120_(hand == player.m_5737_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
    }

    public static HumanoidArm getArmFromHand(InteractionHand hand, Player player) {
        return hand == InteractionHand.MAIN_HAND ? player.m_5737_() : (player.m_5737_() == HumanoidArm.RIGHT ? HumanoidArm.LEFT : HumanoidArm.RIGHT);
    }

    public static boolean holdingLamp(LivingEntity player, HumanoidArm arm) {
        return EntityHelper.getItemInHand(player, arm).m_41720_() == ModItems.SOULSPRING_LAMP;
    }

    public static Vec3 getCenterOf(Entity entity) {
        return entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
    }

    public static GameType getGameModeForPlayer(Player player) {
        GameType gameType;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            gameType = ObjectBuilder.build(() -> {
                Field gameMode = ObfuscationReflectionHelper.findField(ServerPlayer.class, (String)"f_8941_");
                gameMode.setAccessible(true);
                try {
                    return (GameType)gameMode.get(serverPlayer);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        } else {
            gameType = ClientOnlyHelper.getGameMode();
        }
        return gameType;
    }

    public static ServerPlayer getServerPlayer(Player player) {
        return ((MinecraftServer)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER)).m_6846_().m_11259_(player.m_20148_());
    }
}

